/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.HJDError;
import CH.ifa.draw.standard.AbstractTool;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class CreationTool
extends AbstractTool {
    private Point fAnchorPoint;
    private Figure fCreatedFigure;
    private Figure fPrototype;

    protected CreationTool() {
        this.fPrototype = null;
    }

    public CreationTool(Figure prototype) {
        this.fPrototype = prototype;
    }

    public void activate(DrawingView view) {
        view.setCursor(Cursor.getPredefinedCursor(1));
    }

    protected Figure createdFigure() {
        return this.fCreatedFigure;
    }

    protected Figure createFigure(DrawingView view) {
        if (this.fPrototype == null) {
            throw new HJDError("No protoype defined");
        }
        return (Figure)this.fPrototype.clone();
    }

    public void mouseDown(MouseEvent e, int x, int y, DrawingView view) {
        this.fAnchorPoint = new Point(x, y);
        this.fCreatedFigure = this.createFigure(view);
        this.fCreatedFigure.displayBox(this.fAnchorPoint, this.fAnchorPoint);
    }

    public void mouseDrag(MouseEvent e, int x, int y, DrawingView view) {
        this.fCreatedFigure.displayBox(this.fAnchorPoint, new Point(x, y));
    }

    public void mouseUp(MouseEvent e, int x, int y, DrawingView view) {
        if (this.fCreatedFigure.isEmpty()) {
            view.drawing().remove(this.fCreatedFigure);
        } else {
            this.setUndoCommand(view);
        }
        this.fCreatedFigure = null;
        view.editor().toolDone();
    }

    protected void setUndoCommand(DrawingView view) {
        Vector<Figure> v = new Vector<Figure>(1);
        v.addElement(this.createdFigure());
    }
}

